// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: InverseGhostZonePluginInfo.h
// ****************************************************************************

#ifndef INVERSEGHOSTZONE_PLUGIN_INFO_H
#define INVERSEGHOSTZONE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class InverseGhostZoneAttributes;

// ****************************************************************************
//  Class: InverseGhostZonePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an InverseGhostZone operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class InverseGhostZoneGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class InverseGhostZoneCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual InverseGhostZoneGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class InverseGhostZoneGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual InverseGhostZoneCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class InverseGhostZoneViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual InverseGhostZoneCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static InverseGhostZoneAttributes *defaultAtts;
    static InverseGhostZoneAttributes *clientAtts;
};

class InverseGhostZoneViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual InverseGhostZoneViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class InverseGhostZoneEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual InverseGhostZoneViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class InverseGhostZoneScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual InverseGhostZoneCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
