// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: InverseGhostZoneGUIPluginInfo.C
// ****************************************************************************

#include <InverseGhostZonePluginInfo.h>
#include <InverseGhostZoneAttributes.h>
#include <QApplication>
#include <QvisInverseGhostZoneWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(InverseGhostZone,GUI)

// ****************************************************************************
//  Method: InverseGhostZoneGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
InverseGhostZoneGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Inverse Ghost Zone"));
}


// ****************************************************************************
//  Method: InverseGhostZoneGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
InverseGhostZoneGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisInverseGhostZoneWindow(type, (InverseGhostZoneAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: InverseGhostZoneGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <InverseGhostZone.xpm>
const char **
InverseGhostZoneGUIPluginInfo::XPMIconData() const
{
    return InverseGhostZone_xpm;
}

