// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IntegralCurvePluginInfo.h
// ****************************************************************************

#ifndef INTEGRALCURVE_PLUGIN_INFO_H
#define INTEGRALCURVE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class IntegralCurveAttributes;

// ****************************************************************************
//  Class: IntegralCurvePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an IntegralCurve operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class IntegralCurveGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class IntegralCurveCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual IntegralCurveGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
    virtual ExpressionList *GetCreatedExpressions(const avtDatabaseMetaData *) const;
};

class IntegralCurveGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual IntegralCurveCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class IntegralCurveViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual IntegralCurveCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual std::string GetOperatorVarDescription(AttributeSubject *atts,
                                                  const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static IntegralCurveAttributes *defaultAtts;
    static IntegralCurveAttributes *clientAtts;
};

class IntegralCurveViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual IntegralCurveViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class IntegralCurveEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual IntegralCurveViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class IntegralCurveScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual IntegralCurveCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
