// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IntegralCurveGUIPluginInfo.C
// ****************************************************************************

#include <IntegralCurvePluginInfo.h>
#include <IntegralCurveAttributes.h>
#include <QApplication>
#include <QvisIntegralCurveWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(IntegralCurve,GUI)

// ****************************************************************************
//  Method: IntegralCurveGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
IntegralCurveGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "IntegralCurve"));
}


// ****************************************************************************
//  Method: IntegralCurveGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
IntegralCurveGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisIntegralCurveWindow(type, (IntegralCurveAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: IntegralCurveGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <IntegralCurve.xpm>
const char **
IntegralCurveGUIPluginInfo::XPMIconData() const
{
    return IntegralCurve_xpm;
}

