// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IndexSelectPluginInfo.h
// ****************************************************************************

#ifndef INDEXSELECT_PLUGIN_INFO_H
#define INDEXSELECT_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class IndexSelectAttributes;

// ****************************************************************************
//  Class: IndexSelectPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an IndexSelect operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class IndexSelectGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class IndexSelectCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual IndexSelectGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class IndexSelectGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual IndexSelectCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class IndexSelectViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual IndexSelectCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static IndexSelectAttributes *defaultAtts;
    static IndexSelectAttributes *clientAtts;
};

class IndexSelectViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual IndexSelectViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class IndexSelectEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual IndexSelectViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class IndexSelectScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual IndexSelectCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
