// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IndexSelectPluginInfo.C
// ****************************************************************************

#include <IndexSelectPluginInfo.h>
#include <IndexSelectAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(IndexSelect,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(IndexSelect,General)

// ****************************************************************************
//  Method: IndexSelectGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IndexSelectGeneralPluginInfo::GetName() const
{
    return "IndexSelect";
}

// ****************************************************************************
//  Method: IndexSelectGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IndexSelectGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: IndexSelectGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IndexSelectGeneralPluginInfo::GetID() const
{
    return "IndexSelect_1.0";
}
// ****************************************************************************
//  Method: IndexSelectGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
IndexSelectGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: IndexSelectGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IndexSelectGeneralPluginInfo::GetCategoryName() const
{
    return "Selection";
}
