// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISFLUXWINDOW_H
#define QVISFLUXWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class FluxAttributes;
class QLabel;
class QCheckBox;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisFluxWindow
//
// Purpose:
//    Defines QvisFluxWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisFluxWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisFluxWindow(const int type,
                         FluxAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisFluxWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void flowFieldChanged(const QString &varName);
    void weightChanged(bool val);
    void weightFieldChanged(const QString &varName);
  private:
    QvisVariableButton *flowField;
    QCheckBox *weight;
    QvisVariableButton *weightField;
    QLabel *flowFieldLabel;
    QLabel *weightFieldLabel;

    FluxAttributes *atts;
};



#endif
