// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyFluxAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyFluxAttributes
//
// Purpose:
//   Attributes for Flux operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a FluxAttributes.
//
struct FluxAttributesObject
{
    PyObject_HEAD
    FluxAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewFluxAttributes(int);

std::string
PyFluxAttributes_ToString(const FluxAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sflowField = \"%s\"\n", prefix, atts->GetFlowField().c_str());
    str += tmpStr;
    if(atts->GetWeight())
        snprintf(tmpStr, 1000, "%sweight = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sweight = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sweightField = \"%s\"\n", prefix, atts->GetWeightField().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
FluxAttributes_Notify(PyObject *self, PyObject *args)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FluxAttributes_SetFlowField(PyObject *self, PyObject *args)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the flowField in the object.
    obj->data->SetFlowField(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FluxAttributes_GetFlowField(PyObject *self, PyObject *args)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFlowField().c_str());
    return retval;
}

/*static*/ PyObject *
FluxAttributes_SetWeight(PyObject *self, PyObject *args)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the weight in the object.
    obj->data->SetWeight(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FluxAttributes_GetWeight(PyObject *self, PyObject *args)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWeight()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FluxAttributes_SetWeightField(PyObject *self, PyObject *args)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the weightField in the object.
    obj->data->SetWeightField(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FluxAttributes_GetWeightField(PyObject *self, PyObject *args)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetWeightField().c_str());
    return retval;
}



PyMethodDef PyFluxAttributes_methods[FLUXATTRIBUTES_NMETH] = {
    {"Notify", FluxAttributes_Notify, METH_VARARGS},
    {"SetFlowField", FluxAttributes_SetFlowField, METH_VARARGS},
    {"GetFlowField", FluxAttributes_GetFlowField, METH_VARARGS},
    {"SetWeight", FluxAttributes_SetWeight, METH_VARARGS},
    {"GetWeight", FluxAttributes_GetWeight, METH_VARARGS},
    {"SetWeightField", FluxAttributes_SetWeightField, METH_VARARGS},
    {"GetWeightField", FluxAttributes_GetWeightField, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
FluxAttributes_dealloc(PyObject *v)
{
   FluxAttributesObject *obj = (FluxAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
FluxAttributes_compare(PyObject *v, PyObject *w)
{
    FluxAttributes *a = ((FluxAttributesObject *)v)->data;
    FluxAttributes *b = ((FluxAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyFluxAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "flowField") == 0)
        return FluxAttributes_GetFlowField(self, NULL);
    if(strcmp(name, "weight") == 0)
        return FluxAttributes_GetWeight(self, NULL);
    if(strcmp(name, "weightField") == 0)
        return FluxAttributes_GetWeightField(self, NULL);

    return Py_FindMethod(PyFluxAttributes_methods, self, name);
}

int
PyFluxAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "flowField") == 0)
        obj = FluxAttributes_SetFlowField(self, tuple);
    else if(strcmp(name, "weight") == 0)
        obj = FluxAttributes_SetWeight(self, tuple);
    else if(strcmp(name, "weightField") == 0)
        obj = FluxAttributes_SetWeightField(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
FluxAttributes_print(PyObject *v, FILE *fp, int flags)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)v;
    fprintf(fp, "%s", PyFluxAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
FluxAttributes_str(PyObject *v)
{
    FluxAttributesObject *obj = (FluxAttributesObject *)v;
    return PyString_FromString(PyFluxAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *FluxAttributes_Purpose = "Attributes for Flux operator";
#else
static char *FluxAttributes_Purpose = "Attributes for Flux operator";
#endif

//
// The type description structure
//
static PyTypeObject FluxAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "FluxAttributes",                    // tp_name
    sizeof(FluxAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)FluxAttributes_dealloc,  // tp_dealloc
    (printfunc)FluxAttributes_print,     // tp_print
    (getattrfunc)PyFluxAttributes_getattr, // tp_getattr
    (setattrfunc)PyFluxAttributes_setattr, // tp_setattr
    (cmpfunc)FluxAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)FluxAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    FluxAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static FluxAttributes *defaultAtts = 0;
static FluxAttributes *currentAtts = 0;

static PyObject *
NewFluxAttributes(int useCurrent)
{
    FluxAttributesObject *newObject;
    newObject = PyObject_NEW(FluxAttributesObject, &FluxAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new FluxAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new FluxAttributes(*defaultAtts);
    else
        newObject->data = new FluxAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapFluxAttributes(const FluxAttributes *attr)
{
    FluxAttributesObject *newObject;
    newObject = PyObject_NEW(FluxAttributesObject, &FluxAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (FluxAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
FluxAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewFluxAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef FluxAttributesMethods[] = {
    {"FluxAttributes", FluxAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *FluxAttributesObserver = 0;

std::string
PyFluxAttributes_GetLogString()
{
    std::string s("FluxAtts = FluxAttributes()\n");
    if(currentAtts != 0)
        s += PyFluxAttributes_ToString(currentAtts, "FluxAtts.");
    return s;
}

static void
PyFluxAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("FluxAtts = FluxAttributes()\n");
        s += PyFluxAttributes_ToString(currentAtts, "FluxAtts.");
        cb(s);
    }
}

void
PyFluxAttributes_StartUp(FluxAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyFluxAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(FluxAttributesObserver == 0)
    {
        FluxAttributesObserver = new ObserverToCallback(subj,
            PyFluxAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyFluxAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete FluxAttributesObserver;
    FluxAttributesObserver = 0;
}

PyMethodDef *
PyFluxAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return FluxAttributesMethods;
}

bool
PyFluxAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &FluxAttributesType);
}

FluxAttributes *
PyFluxAttributes_FromPyObject(PyObject *obj)
{
    FluxAttributesObject *obj2 = (FluxAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyFluxAttributes_New()
{
    return NewFluxAttributes(0);
}

PyObject *
PyFluxAttributes_Wrap(const FluxAttributes *attr)
{
    return WrapFluxAttributes(attr);
}

void
PyFluxAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    FluxAttributesObject *obj2 = (FluxAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyFluxAttributes_SetDefaults(const FluxAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new FluxAttributes(*atts);
}

