// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef FLUXATTRIBUTES_H
#define FLUXATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: FluxAttributes
//
// Purpose:
//    Attributes for Flux operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class FluxAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    FluxAttributes();
    FluxAttributes(const FluxAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    FluxAttributes(private_tmfs_t tmfs);
    FluxAttributes(const FluxAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~FluxAttributes();

    virtual FluxAttributes& operator = (const FluxAttributes &obj);
    virtual bool operator == (const FluxAttributes &obj) const;
    virtual bool operator != (const FluxAttributes &obj) const;
private:
    void Init();
    void Copy(const FluxAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectFlowField();
    void SelectWeightField();

    // Property setting methods
    void SetFlowField(const std::string &flowField_);
    void SetWeight(bool weight_);
    void SetWeightField(const std::string &weightField_);

    // Property getting methods
    const std::string &GetFlowField() const;
          std::string &GetFlowField();
    bool              GetWeight() const;
    const std::string &GetWeightField() const;
          std::string &GetWeightField();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_flowField = 0,
        ID_weight,
        ID_weightField,
        ID__LAST
    };

private:
    std::string flowField;
    bool        weight;
    std::string weightField;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define FLUXATTRIBUTES_TMFS "sbs"

#endif
