// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <FluxAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: FluxAttributes::FluxAttributes
//
// Purpose:
//   Init utility for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void FluxAttributes::Init()
{
    weight = false;

    FluxAttributes::SelectAll();
}

// ****************************************************************************
// Method: FluxAttributes::FluxAttributes
//
// Purpose:
//   Copy utility for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void FluxAttributes::Copy(const FluxAttributes &obj)
{
    flowField = obj.flowField;
    weight = obj.weight;
    weightField = obj.weightField;

    FluxAttributes::SelectAll();
}

// Type map format string
const char *FluxAttributes::TypeMapFormatString = FLUXATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t FluxAttributes::TmfsStruct = {FLUXATTRIBUTES_TMFS};


// ****************************************************************************
// Method: FluxAttributes::FluxAttributes
//
// Purpose:
//   Default constructor for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FluxAttributes::FluxAttributes() :
    AttributeSubject(FluxAttributes::TypeMapFormatString),
    flowField("default"), weightField("default")
{
    FluxAttributes::Init();
}

// ****************************************************************************
// Method: FluxAttributes::FluxAttributes
//
// Purpose:
//   Constructor for the derived classes of FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FluxAttributes::FluxAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    flowField("default"), weightField("default")
{
    FluxAttributes::Init();
}

// ****************************************************************************
// Method: FluxAttributes::FluxAttributes
//
// Purpose:
//   Copy constructor for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FluxAttributes::FluxAttributes(const FluxAttributes &obj) :
    AttributeSubject(FluxAttributes::TypeMapFormatString)
{
    FluxAttributes::Copy(obj);
}

// ****************************************************************************
// Method: FluxAttributes::FluxAttributes
//
// Purpose:
//   Copy constructor for derived classes of the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FluxAttributes::FluxAttributes(const FluxAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    FluxAttributes::Copy(obj);
}

// ****************************************************************************
// Method: FluxAttributes::~FluxAttributes
//
// Purpose:
//   Destructor for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FluxAttributes::~FluxAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: FluxAttributes::operator =
//
// Purpose:
//   Assignment operator for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

FluxAttributes&
FluxAttributes::operator = (const FluxAttributes &obj)
{
    if (this == &obj) return *this;

    FluxAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: FluxAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FluxAttributes::operator == (const FluxAttributes &obj) const
{
    // Create the return value
    return ((flowField == obj.flowField) &&
            (weight == obj.weight) &&
            (weightField == obj.weightField));
}

// ****************************************************************************
// Method: FluxAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FluxAttributes::operator != (const FluxAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: FluxAttributes::TypeName
//
// Purpose:
//   Type name method for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
FluxAttributes::TypeName() const
{
    return "FluxAttributes";
}

// ****************************************************************************
// Method: FluxAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FluxAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const FluxAttributes *tmp = (const FluxAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: FluxAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
FluxAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new FluxAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: FluxAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the FluxAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
FluxAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new FluxAttributes(*this);
    else
        retval = new FluxAttributes;

    return retval;
}

// ****************************************************************************
// Method: FluxAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FluxAttributes::SelectAll()
{
    Select(ID_flowField,   (void *)&flowField);
    Select(ID_weight,      (void *)&weight);
    Select(ID_weightField, (void *)&weightField);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: FluxAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FluxAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    FluxAttributes defaultObject;
    bool addToParent = false;
    // Create a node for FluxAttributes.
    DataNode *node = new DataNode("FluxAttributes");

    if(completeSave || !FieldsEqual(ID_flowField, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("flowField", flowField));
    }

    if(completeSave || !FieldsEqual(ID_weight, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("weight", weight));
    }

    if(completeSave || !FieldsEqual(ID_weightField, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("weightField", weightField));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: FluxAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FluxAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("FluxAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("flowField")) != 0)
        SetFlowField(node->AsString());
    if((node = searchNode->GetNode("weight")) != 0)
        SetWeight(node->AsBool());
    if((node = searchNode->GetNode("weightField")) != 0)
        SetWeightField(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
FluxAttributes::SetFlowField(const std::string &flowField_)
{
    flowField = flowField_;
    Select(ID_flowField, (void *)&flowField);
}

void
FluxAttributes::SetWeight(bool weight_)
{
    weight = weight_;
    Select(ID_weight, (void *)&weight);
}

void
FluxAttributes::SetWeightField(const std::string &weightField_)
{
    weightField = weightField_;
    Select(ID_weightField, (void *)&weightField);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
FluxAttributes::GetFlowField() const
{
    return flowField;
}

std::string &
FluxAttributes::GetFlowField()
{
    return flowField;
}

bool
FluxAttributes::GetWeight() const
{
    return weight;
}

const std::string &
FluxAttributes::GetWeightField() const
{
    return weightField;
}

std::string &
FluxAttributes::GetWeightField()
{
    return weightField;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
FluxAttributes::SelectFlowField()
{
    Select(ID_flowField, (void *)&flowField);
}

void
FluxAttributes::SelectWeightField()
{
    Select(ID_weightField, (void *)&weightField);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: FluxAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
FluxAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_flowField:   return "flowField";
    case ID_weight:      return "weight";
    case ID_weightField: return "weightField";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: FluxAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
FluxAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_flowField:   return FieldType_variablename;
    case ID_weight:      return FieldType_bool;
    case ID_weightField: return FieldType_variablename;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: FluxAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
FluxAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_flowField:   return "variablename";
    case ID_weight:      return "bool";
    case ID_weightField: return "variablename";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: FluxAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FluxAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const FluxAttributes &obj = *((const FluxAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_flowField:
        {  // new scope
        retval = (flowField == obj.flowField);
        }
        break;
    case ID_weight:
        {  // new scope
        retval = (weight == obj.weight);
        }
        break;
    case ID_weightField:
        {  // new scope
        retval = (weightField == obj.weightField);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

