// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtFiveFoldTetSubdivisionFilter.h
// ************************************************************************* //

#ifndef AVT_FiveFoldTetSubdivision_FILTER_H
#define AVT_FiveFoldTetSubdivision_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <FiveFoldTetSubdivisionAttributes.h>
#include <Branch.h>

#include <vtkType.h>


// ****************************************************************************
//  Class: avtFiveFoldTetSubdivisionFilter
//
//  Purpose:
//      A plugin operator for FiveFoldTetSubdivision.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Mon Jun 20 14:54:18 PST 2011
//
//  Modifications:
//    Eric Brugger, Mon Jul 28 15:27:33 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtFiveFoldTetSubdivisionFilter : public avtPluginDataTreeIterator
{
  public:
                         avtFiveFoldTetSubdivisionFilter();
    virtual             ~avtFiveFoldTetSubdivisionFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtFiveFoldTetSubdivisionFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Five Fold Tet Subdvision"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    FiveFoldTetSubdivisionAttributes   atts;
    std::string                        mainVar;
    Branch                            *contourTree;
    const Branch                     **idToBranchMap;
    char                              *selectedOrHighlighted;

    virtual void          UpdateDataObjectInfo(void);
    virtual avtContract_p ModifyContract(avtContract_p);
    virtual void          PreExecute(void);
    void addBranchIds(vtkIdType [4], vtkDataArray *, vtkDataArray *, vtkDataArray *, vtkDataArray *, vtkDataArray *, vtkDataArray *, vtkDataArray *);
    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
};

#endif
