// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  FiveFoldTetSubdivisionScriptingPluginInfo.C
// ************************************************************************* //
#include <PyFiveFoldTetSubdivisionAttributes.h>
#include <FiveFoldTetSubdivisionPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(FiveFoldTetSubdivision,Scripting)

// ****************************************************************************
// Method: FiveFoldTetSubdivisionScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FiveFoldTetSubdivisionScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyFiveFoldTetSubdivisionAttributes_StartUp((FiveFoldTetSubdivisionAttributes *)subj, data);
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
FiveFoldTetSubdivisionScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyFiveFoldTetSubdivisionAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is FiveFoldTetSubdivision plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FiveFoldTetSubdivisionScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyFiveFoldTetSubdivisionAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
FiveFoldTetSubdivisionScriptingPluginInfo::GetLogString()
{
    std::string s(PyFiveFoldTetSubdivisionAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FiveFoldTetSubdivisionScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyFiveFoldTetSubdivisionAttributes_SetDefaults((const FiveFoldTetSubdivisionAttributes *)atts);
}
