// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef FIVEFOLDTETSUBDIVISIONATTRIBUTES_H
#define FIVEFOLDTETSUBDIVISIONATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: FiveFoldTetSubdivisionAttributes
//
// Purpose:
//    Attributes for five fold tetrahedral subdivision operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class FiveFoldTetSubdivisionAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    FiveFoldTetSubdivisionAttributes();
    FiveFoldTetSubdivisionAttributes(const FiveFoldTetSubdivisionAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    FiveFoldTetSubdivisionAttributes(private_tmfs_t tmfs);
    FiveFoldTetSubdivisionAttributes(const FiveFoldTetSubdivisionAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~FiveFoldTetSubdivisionAttributes();

    virtual FiveFoldTetSubdivisionAttributes& operator = (const FiveFoldTetSubdivisionAttributes &obj);
    virtual bool operator == (const FiveFoldTetSubdivisionAttributes &obj) const;
    virtual bool operator != (const FiveFoldTetSubdivisionAttributes &obj) const;
private:
    void Init();
    void Copy(const FiveFoldTetSubdivisionAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectIdVar();
    void SelectValueVar();
    void SelectContourTreeFilename();
    void SelectSelectedIds();
    void SelectHighlightedIds();

    // Property setting methods
    void SetOddParityHasSixNeighborhood(bool oddParityHasSixNeighborhood_);
    void SetAddComponentInformation(bool addComponentInformation_);
    void SetIdVar(const std::string &idVar_);
    void SetValueVar(const std::string &valueVar_);
    void SetContourTreeFilename(const std::string &contourTreeFilename_);
    void SetIsovalue(double isovalue_);
    void SetSelectedIds(const intVector &selectedIds_);
    void SetHighlightedIds(const intVector &highlightedIds_);

    // Property getting methods
    bool              GetOddParityHasSixNeighborhood() const;
    bool              GetAddComponentInformation() const;
    const std::string &GetIdVar() const;
          std::string &GetIdVar();
    const std::string &GetValueVar() const;
          std::string &GetValueVar();
    const std::string &GetContourTreeFilename() const;
          std::string &GetContourTreeFilename();
    double            GetIsovalue() const;
    const intVector   &GetSelectedIds() const;
          intVector   &GetSelectedIds();
    const intVector   &GetHighlightedIds() const;
          intVector   &GetHighlightedIds();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_oddParityHasSixNeighborhood = 0,
        ID_addComponentInformation,
        ID_idVar,
        ID_valueVar,
        ID_contourTreeFilename,
        ID_isovalue,
        ID_selectedIds,
        ID_highlightedIds,
        ID__LAST
    };

private:
    bool        oddParityHasSixNeighborhood;
    bool        addComponentInformation;
    std::string idVar;
    std::string valueVar;
    std::string contourTreeFilename;
    double      isovalue;
    intVector   selectedIds;
    intVector   highlightedIds;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define FIVEFOLDTETSUBDIVISIONATTRIBUTES_TMFS "bbsssdi*i*"

#endif
