// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisFFTWindow.h"

#include <FFTAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisFFTWindow::QvisFFTWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisFFTWindow::QvisFFTWindow(const int type,
                         FFTAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisFFTWindow::~QvisFFTWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisFFTWindow::~QvisFFTWindow()
{
}


// ****************************************************************************
// Method: QvisFFTWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFFTWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    dummyLabel = new QLabel(tr("Dummy attribute"), central);
    mainLayout->addWidget(dummyLabel,0,0);
    dummy = new QLineEdit(central);
    connect(dummy, SIGNAL(returnPressed()),
            this, SLOT(dummyProcessText()));
    mainLayout->addWidget(dummy, 0,1);

}


// ****************************************************************************
// Method: QvisFFTWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFFTWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case FFTAttributes::ID_dummy:
            dummy->setText(IntToQString(atts->GetDummy()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisFFTWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFFTWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do dummy
    if(which_widget == FFTAttributes::ID_dummy || doAll)
    {
        int val;
        if(LineEditGetInt(dummy, val))
            atts->SetDummy(val);
        else
        {
            ResettingError(tr("Dummy attribute"),
                IntToQString(atts->GetDummy()));
            atts->SetDummy(atts->GetDummy());
        }
    }

}


//
// Qt Slot functions
//


void
QvisFFTWindow::dummyProcessText()
{
    GetCurrentValues(FFTAttributes::ID_dummy);
    Apply();
}


