// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FFTCommonPluginInfo.C
// ****************************************************************************

#include <FFTPluginInfo.h>
#include <FFTAttributes.h>

// ****************************************************************************
//  Method: FFTCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
FFTCommonPluginInfo::AllocAttributes()
{
    return new FFTAttributes;
}

// ****************************************************************************
//  Method: FFTCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a FFT attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
FFTCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((FFTAttributes *) to) = *((FFTAttributes *) from);
}
