// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisExtrudeWindow.h"

#include <ExtrudeAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisExtrudeWindow::QvisExtrudeWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisExtrudeWindow::QvisExtrudeWindow(const int type,
                                     ExtrudeAttributes *subj,
                                     const QString &caption,
                                     const QString &shortName,
                                     QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisExtrudeWindow::~QvisExtrudeWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisExtrudeWindow::~QvisExtrudeWindow()
{
}


// ****************************************************************************
// Method: QvisExtrudeWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisExtrudeWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    axisLabel = new QLabel(tr("Extrusion axis"), central);
    mainLayout->addWidget(axisLabel,0,0);
    axis = new QLineEdit(central);
    connect(axis, SIGNAL(returnPressed()),
            this, SLOT(axisProcessText()));
    mainLayout->addWidget(axis, 0,1);
    
    byVariable = new QCheckBox(tr("Extrude by variable"), central);
    connect(byVariable, SIGNAL(toggled(bool)),
            this, SLOT(byVariableChanged(bool)));
    mainLayout->addWidget(byVariable, 1,0);

    int variableMask = QvisVariableButton::Scalars;
    variable = new QvisVariableButton(true, true, true, variableMask, central);
    variable->setDefaultVariable("default");
    variable->setEnabled( atts->GetByVariable() );
    connect(variable, SIGNAL(activated(const QString&)),
            this, SLOT(variableChanged(const QString&)));
    mainLayout->addWidget(variable, 1,1);

    lengthLabel = new QLabel(tr("Length"), central);
    mainLayout->addWidget(lengthLabel,2,0);
    length = new QLineEdit(central);
    connect(length, SIGNAL(returnPressed()),
            this, SLOT(lengthProcessText()));
    mainLayout->addWidget(length, 2,1);

    stepsLabel = new QLabel(tr("Number of steps"), central);
    mainLayout->addWidget(stepsLabel,3,0);
    steps = new QLineEdit(central);
    connect(steps, SIGNAL(returnPressed()),
            this, SLOT(stepsProcessText()));
    mainLayout->addWidget(steps, 3,1);

    preserveOriginalCellNumbers = new QCheckBox(tr("Preserve original cell numbers"), central);
    connect(preserveOriginalCellNumbers, SIGNAL(toggled(bool)),
            this, SLOT(preserveOriginalCellNumbersChanged(bool)));
    mainLayout->addWidget(preserveOriginalCellNumbers, 4,0);

}


// ****************************************************************************
// Method: QvisExtrudeWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisExtrudeWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ExtrudeAttributes::ID_axis:
            axis->setText(DoublesToQString(atts->GetAxis(), 3));
            break;
          case ExtrudeAttributes::ID_byVariable:
            byVariable->blockSignals(true);
            byVariable->setChecked(atts->GetByVariable());
            byVariable->blockSignals(false);

            if(atts->GetByVariable())
              lengthLabel->setText("Scale Factor");
            else
              lengthLabel->setText("Length");
            break;
          case ExtrudeAttributes::ID_variable:
            variable->blockSignals(true);
            variable->setText(QString(atts->GetVariable().c_str()));
            variable->blockSignals(false);
            break;
          case ExtrudeAttributes::ID_length:
            length->setText(DoubleToQString(atts->GetLength()));
            break;
          case ExtrudeAttributes::ID_steps:
            steps->setText(IntToQString(atts->GetSteps()));
            break;
          case ExtrudeAttributes::ID_preserveOriginalCellNumbers:
            preserveOriginalCellNumbers->blockSignals(true);
            preserveOriginalCellNumbers->setChecked(atts->GetPreserveOriginalCellNumbers());
            preserveOriginalCellNumbers->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisExtrudeWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisExtrudeWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do axis
    if(which_widget == ExtrudeAttributes::ID_axis || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(axis, val, 3))
            atts->SetAxis(val);
        else
        {
            ResettingError(tr("Extrusion axis"),
                DoublesToQString(atts->GetAxis(),3));
            atts->SetAxis(atts->GetAxis());
        }
    }

    // Do length
    if(which_widget == ExtrudeAttributes::ID_length || doAll)
    {
        double val;
        if(LineEditGetDouble(length, val))
            atts->SetLength(val);
        else
        {
            ResettingError(tr("Length"),
                DoubleToQString(atts->GetLength()));
            atts->SetLength(atts->GetLength());
        }
    }

    // Do steps
    if(which_widget == ExtrudeAttributes::ID_steps || doAll)
    {
        int val;
        if(LineEditGetInt(steps, val))
            atts->SetSteps(val);
        else
        {
            ResettingError(tr("Number of steps"),
                IntToQString(atts->GetSteps()));
            atts->SetSteps(atts->GetSteps());
        }
    }
}


//
// Qt Slot functions
//


void
QvisExtrudeWindow::axisProcessText()
{
    GetCurrentValues(ExtrudeAttributes::ID_axis);
    Apply();
}


void
QvisExtrudeWindow::byVariableChanged(bool val)
{
    atts->SetByVariable(val);

    variable->setEnabled( atts->GetByVariable() );

    if(atts->GetByVariable())
      lengthLabel->setText("Scale Factor");
    else
      lengthLabel->setText("Length");
    
    SetUpdate(false);
    Apply();
}

void
QvisExtrudeWindow::variableChanged(const QString &varName)
{
    atts->SetVariable(varName.toStdString());
    SetUpdate(false);
    Apply();
}

void
QvisExtrudeWindow::lengthProcessText()
{
    GetCurrentValues(ExtrudeAttributes::ID_length);
    Apply();
}


void
QvisExtrudeWindow::stepsProcessText()
{
    GetCurrentValues(ExtrudeAttributes::ID_steps);
    Apply();
}


void
QvisExtrudeWindow::preserveOriginalCellNumbersChanged(bool val)
{
    atts->SetPreserveOriginalCellNumbers(val);
    SetUpdate(false);
    Apply();
}
