// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ExtrudeScriptingPluginInfo.C
// ************************************************************************* //
#include <PyExtrudeAttributes.h>
#include <ExtrudePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Extrude,Scripting)

// ****************************************************************************
// Method: ExtrudeScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ExtrudeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyExtrudeAttributes_StartUp((ExtrudeAttributes *)subj, data);
}

// ****************************************************************************
// Method: ExtrudeScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ExtrudeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyExtrudeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ExtrudeScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Extrude plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ExtrudeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyExtrudeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ExtrudeScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ExtrudeScriptingPluginInfo::GetLogString()
{
    std::string s(PyExtrudeAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ExtrudeScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ExtrudeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyExtrudeAttributes_SetDefaults((const ExtrudeAttributes *)atts);
}
