// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtExtractPointFunction2DFilter.h
// ************************************************************************* //

#ifndef AVT_ExtractPointFunction2D_FILTER_H
#define AVT_ExtractPointFunction2D_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <ExtractPointFunction2DAttributes.h>


// ****************************************************************************
//  Class: avtExtractPointFunction2DFilter
//
//  Purpose:
//      A plugin operator for ExtractPointFunction2D.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Jun 4 10:46:56 PDT 2013
//
//  Modifications:
//    Eric Brugger, Thu Jul 24 13:26:47 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtExtractPointFunction2DFilter : public avtPluginDataTreeIterator
{
  public:
                                     avtExtractPointFunction2DFilter();
    virtual                         ~avtExtractPointFunction2DFilter();

    static avtFilter                *Create();

    virtual const char              *GetType(void)
                                         { return "avtExtractPointFunction2DFilter"; };
    virtual const char              *GetDescription(void)
                                         { return "Extract Point Function 2D"; };

    virtual void                     SetAtts(const AttributeGroup*);
    virtual bool                     Equivalent(const AttributeGroup*);

    virtual avtContract_p            ModifyContract(avtContract_p);
    virtual void                     UpdateDataObjectInfo(void);
  protected:
    ExtractPointFunction2DAttributes atts;
    std::string                      outVarName;

    virtual void                     PreExecute(void);
    virtual void                     Execute(void);
    virtual avtDataRepresentation   *ExecuteData(avtDataRepresentation *in_dr)
                                         { return in_dr; } // NOT CALLED: OVERRIDE BY Execute()
    virtual void                     PostExecute(void);

  private:
    double                           spatialExtents[6];
    double                           range[2];
};

#endif
