// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISEXTRACTPOINTFUNCTION2DWINDOW_H
#define QVISEXTRACTPOINTFUNCTION2DWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class ExtractPointFunction2DAttributes;
class QLabel;
class QLineEdit;

// ****************************************************************************
// Class: QvisExtractPointFunction2DWindow
//
// Purpose:
//    Defines QvisExtractPointFunction2DWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisExtractPointFunction2DWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisExtractPointFunction2DWindow(const int type,
                         ExtractPointFunction2DAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisExtractPointFunction2DWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void IProcessText();
    void JProcessText();
  private:
    QLineEdit *I;
    QLineEdit *J;
    QLabel *ILabel;
    QLabel *JLabel;

    ExtractPointFunction2DAttributes *atts;
};



#endif
