// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtractPointFunction2DViewerEnginePluginInfo.C
// ****************************************************************************

#include <ExtractPointFunction2DPluginInfo.h>
#include <ExtractPointFunction2DAttributes.h>

//
// Storage for static data elements.
//
ExtractPointFunction2DAttributes *ExtractPointFunction2DViewerEnginePluginInfo::clientAtts = NULL;
ExtractPointFunction2DAttributes *ExtractPointFunction2DViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ExtractPointFunction2DViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ExtractPointFunction2DViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ExtractPointFunction2DViewerEnginePluginInfo::clientAtts == NULL)
    {
        ExtractPointFunction2DViewerEnginePluginInfo::clientAtts  = new ExtractPointFunction2DAttributes;
        ExtractPointFunction2DViewerEnginePluginInfo::defaultAtts = new ExtractPointFunction2DAttributes;
    }
}

// ****************************************************************************
//  Method: ExtractPointFunction2DViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ExtractPointFunction2DViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ExtractPointFunction2DViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ExtractPointFunction2DViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ExtractPointFunction2DViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExtractPointFunction2DViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ExtractPointFunction2DAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ExtractPointFunction2DViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExtractPointFunction2DViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ExtractPointFunction2DAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ExtractPointFunction2DViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExtractPointFunction2DViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ExtractPointFunction2DAttributes*)atts = *defaultAtts;
    else
        *(ExtractPointFunction2DAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: ExtractPointFunction2DViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExtractPointFunction2DViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: ExtractPointFunction2DViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExtractPointFunction2DViewerEnginePluginInfo::GetMenuName() const
{
    return "Extract Point Function 2D";
}

