// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ExtractPointFunction2DScriptingPluginInfo.C
// ************************************************************************* //
#include <PyExtractPointFunction2DAttributes.h>
#include <ExtractPointFunction2DPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(ExtractPointFunction2D,Scripting)

// ****************************************************************************
// Method: ExtractPointFunction2DScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ExtractPointFunction2DScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyExtractPointFunction2DAttributes_StartUp((ExtractPointFunction2DAttributes *)subj, data);
}

// ****************************************************************************
// Method: ExtractPointFunction2DScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ExtractPointFunction2DScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyExtractPointFunction2DAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ExtractPointFunction2DScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is ExtractPointFunction2D plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ExtractPointFunction2DScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyExtractPointFunction2DAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ExtractPointFunction2DScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ExtractPointFunction2DScriptingPluginInfo::GetLogString()
{
    std::string s(PyExtractPointFunction2DAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ExtractPointFunction2DScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ExtractPointFunction2DScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyExtractPointFunction2DAttributes_SetDefaults((const ExtractPointFunction2DAttributes *)atts);
}
