// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtractPointFunction2DCommonPluginInfo.C
// ****************************************************************************

#include <ExtractPointFunction2DPluginInfo.h>
#include <ExtractPointFunction2DAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtArrayMetaData.h>

// ****************************************************************************
//  Method: ExtractPointFunction2DCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ExtractPointFunction2DCommonPluginInfo::AllocAttributes()
{
    return new ExtractPointFunction2DAttributes;
}

// ****************************************************************************
//  Method: ExtractPointFunction2DCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a ExtractPointFunction2D attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExtractPointFunction2DCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ExtractPointFunction2DAttributes *) to) = *((ExtractPointFunction2DAttributes *) from);
}
ExpressionList *
ExtractPointFunction2DCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    char name[1024];
    char defn[1024];
    ExpressionList *el = new ExpressionList;

    for (int i = 0 ; i < md->GetNumArrays() ; i++)
    {
        const char *array = md->GetArrays(i).name.c_str();
        const char *mesh = md->GetArrays(i).meshName.c_str();

        if (md->GetArrays(i).hideFromGUI || !md->GetArrays(i).validVariable)
            continue;

        Expression e;
        sprintf(name, "operators/ExtractPointFunction2D/%s", array);
        e.SetName(name);
        e.SetType(Expression::ScalarMeshVar);
        e.SetFromOperator(true);
        e.SetOperatorName("ExtractPointFunction2D");
        sprintf(defn, "cell_constant(<%s>, 0)", mesh);
        e.SetDefinition(defn);
        el->AddExpressions(e);
    }

    const ExpressionList &oldEL = md->GetExprList();
    for (int i = 0 ; i < oldEL.GetNumExpressions() ; i++)
    {
        const Expression &e = oldEL.GetExpressions(i);
        if (e.GetType() == Expression::ArrayMeshVar)
        {
            {
                if (e.GetFromOperator() || e.GetAutoExpression())
                    continue; // weird ordering behavior otherwise
                Expression e2;
                sprintf(name, "operators/ExtractPointFunction2D/%s", e.GetName().c_str());
                e2.SetName(name);
                e2.SetType(Expression::ScalarMeshVar);
                e2.SetFromOperator(true);
                e2.SetOperatorName("ExtractPointFunction2D");
                sprintf(defn, "cell_constant(<%s>, 0.)", e.GetName().c_str());
                e2.SetDefinition(defn);
                el->AddExpressions(e2);
            }
        }
    }

    return el;
}

