// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import java.lang.Integer;
import java.util.Vector;

// ****************************************************************************
// Class: ExtractPointFunction2DAttributes
//
// Purpose:
//    Attributes for ExtractPointFunction2D
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class ExtractPointFunction2DAttributes extends AttributeSubject implements Plugin
{
    private static int ExtractPointFunction2DAttributes_numAdditionalAtts = 2;

    public ExtractPointFunction2DAttributes()
    {
        super(ExtractPointFunction2DAttributes_numAdditionalAtts);

        I = new Vector();
        J = new Vector();
    }

    public ExtractPointFunction2DAttributes(int nMoreFields)
    {
        super(ExtractPointFunction2DAttributes_numAdditionalAtts + nMoreFields);

        I = new Vector();
        J = new Vector();
    }

    public ExtractPointFunction2DAttributes(ExtractPointFunction2DAttributes obj)
    {
        super(obj);

        int i;

        I = new Vector();
        for(i = 0; i < obj.I.size(); ++i)
        {
            Integer iv = (Integer)obj.I.elementAt(i);
            I.addElement(new Integer(iv.intValue()));
        }
        J = new Vector();
        for(i = 0; i < obj.J.size(); ++i)
        {
            Integer iv = (Integer)obj.J.elementAt(i);
            J.addElement(new Integer(iv.intValue()));
        }

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ExtractPointFunction2DAttributes_numAdditionalAtts;
    }

    public boolean equals(ExtractPointFunction2DAttributes obj)
    {
        int i;

        // Compare the elements in the I vector.
        boolean I_equal = (obj.I.size() == I.size());
        for(i = 0; (i < I.size()) && I_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer I1 = (Integer)I.elementAt(i);
            Integer I2 = (Integer)obj.I.elementAt(i);
            I_equal = I1.equals(I2);
        }
        // Compare the elements in the J vector.
        boolean J_equal = (obj.J.size() == J.size());
        for(i = 0; (i < J.size()) && J_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer J1 = (Integer)J.elementAt(i);
            Integer J2 = (Integer)obj.J.elementAt(i);
            J_equal = J1.equals(J2);
        }
        // Create the return value
        return (I_equal &&
                J_equal);
    }

    public String GetName() { return "ExtractPointFunction2D"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetI(Vector I_)
    {
        I = I_;
        Select(0);
    }

    public void SetJ(Vector J_)
    {
        J = J_;
        Select(1);
    }

    // Property getting methods
    public Vector GetI() { return I; }
    public Vector GetJ() { return J; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteIntVector(I);
        if(WriteSelect(1, buf))
            buf.WriteIntVector(J);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetI(buf.ReadIntVector());
            break;
        case 1:
            SetJ(buf.ReadIntVector());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intVectorToString("I", I, indent) + "\n";
        str = str + intVectorToString("J", J, indent) + "\n";
        return str;
    }


    // Attributes
    private Vector I; // vector of Integer objects
    private Vector J; // vector of Integer objects
}

