// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef EXTRACTPOINTFUNCTION2DATTRIBUTES_H
#define EXTRACTPOINTFUNCTION2DATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ExtractPointFunction2DAttributes
//
// Purpose:
//    Attributes for ExtractPointFunction2D
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class ExtractPointFunction2DAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ExtractPointFunction2DAttributes();
    ExtractPointFunction2DAttributes(const ExtractPointFunction2DAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ExtractPointFunction2DAttributes(private_tmfs_t tmfs);
    ExtractPointFunction2DAttributes(const ExtractPointFunction2DAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ExtractPointFunction2DAttributes();

    virtual ExtractPointFunction2DAttributes& operator = (const ExtractPointFunction2DAttributes &obj);
    virtual bool operator == (const ExtractPointFunction2DAttributes &obj) const;
    virtual bool operator != (const ExtractPointFunction2DAttributes &obj) const;
private:
    void Init();
    void Copy(const ExtractPointFunction2DAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectI();
    void SelectJ();

    // Property setting methods
    void SetI(const intVector &I_);
    void SetJ(const intVector &J_);

    // Property getting methods
    const intVector &GetI() const;
          intVector &GetI();
    const intVector &GetJ() const;
          intVector &GetJ();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_I = 0,
        ID_J,
        ID__LAST
    };

private:
    intVector I;
    intVector J;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define EXTRACTPOINTFUNCTION2DATTRIBUTES_TMFS "i*i*"

#endif
