// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExternalSurfaceViewerEnginePluginInfo.C
// ****************************************************************************

#include <ExternalSurfacePluginInfo.h>
#include <ExternalSurfaceAttributes.h>

//
// Storage for static data elements.
//
ExternalSurfaceAttributes *ExternalSurfaceViewerEnginePluginInfo::clientAtts = NULL;
ExternalSurfaceAttributes *ExternalSurfaceViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ExternalSurfaceViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ExternalSurfaceViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ExternalSurfaceViewerEnginePluginInfo::clientAtts == NULL)
    {
        ExternalSurfaceViewerEnginePluginInfo::clientAtts  = new ExternalSurfaceAttributes;
        ExternalSurfaceViewerEnginePluginInfo::defaultAtts = new ExternalSurfaceAttributes;
    }
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ExternalSurfaceViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ExternalSurfaceViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExternalSurfaceViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ExternalSurfaceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExternalSurfaceViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ExternalSurfaceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExternalSurfaceViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ExternalSurfaceAttributes*)atts = *defaultAtts;
    else
        *(ExternalSurfaceAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExternalSurfaceViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: ExternalSurfaceViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExternalSurfaceViewerEnginePluginInfo::GetMenuName() const
{
    return "External Surface";
}

