// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExternalSurfaceCommonPluginInfo.C
// ****************************************************************************

#include <ExternalSurfacePluginInfo.h>
#include <ExternalSurfaceAttributes.h>

// ****************************************************************************
//  Method: ExternalSurfaceCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ExternalSurfaceCommonPluginInfo::AllocAttributes()
{
    return new ExternalSurfaceAttributes;
}

// ****************************************************************************
//  Method: ExternalSurfaceCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a ExternalSurface attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExternalSurfaceCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ExternalSurfaceAttributes *) to) = *((ExternalSurfaceAttributes *) from);
}
