// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: ExternalSurfaceAttributes
//
// Purpose:
//    This class contains attributes for the external surface operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class ExternalSurfaceAttributes extends AttributeSubject implements Plugin
{
    private static int ExternalSurfaceAttributes_numAdditionalAtts = 2;

    public ExternalSurfaceAttributes()
    {
        super(ExternalSurfaceAttributes_numAdditionalAtts);

        removeGhosts = false;
        edgesIn2D = true;
    }

    public ExternalSurfaceAttributes(int nMoreFields)
    {
        super(ExternalSurfaceAttributes_numAdditionalAtts + nMoreFields);

        removeGhosts = false;
        edgesIn2D = true;
    }

    public ExternalSurfaceAttributes(ExternalSurfaceAttributes obj)
    {
        super(obj);

        removeGhosts = obj.removeGhosts;
        edgesIn2D = obj.edgesIn2D;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ExternalSurfaceAttributes_numAdditionalAtts;
    }

    public boolean equals(ExternalSurfaceAttributes obj)
    {
        // Create the return value
        return ((removeGhosts == obj.removeGhosts) &&
                (edgesIn2D == obj.edgesIn2D));
    }

    public String GetName() { return "ExternalSurface"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetRemoveGhosts(boolean removeGhosts_)
    {
        removeGhosts = removeGhosts_;
        Select(0);
    }

    public void SetEdgesIn2D(boolean edgesIn2D_)
    {
        edgesIn2D = edgesIn2D_;
        Select(1);
    }

    // Property getting methods
    public boolean GetRemoveGhosts() { return removeGhosts; }
    public boolean GetEdgesIn2D() { return edgesIn2D; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(removeGhosts);
        if(WriteSelect(1, buf))
            buf.WriteBool(edgesIn2D);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetRemoveGhosts(buf.ReadBool());
            break;
        case 1:
            SetEdgesIn2D(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + boolToString("removeGhosts", removeGhosts, indent) + "\n";
        str = str + boolToString("edgesIn2D", edgesIn2D, indent) + "\n";
        return str;
    }


    // Attributes
    private boolean removeGhosts;
    private boolean edgesIn2D;
}

