// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExplodeCommonPluginInfo.C
// ****************************************************************************

#include <ExplodePluginInfo.h>
#include <ExplodeAttributes.h>

// ****************************************************************************
//  Method: ExplodeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ExplodeCommonPluginInfo::AllocAttributes()
{
    return new ExplodeAttributes;
}

// ****************************************************************************
//  Method: ExplodeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Explode attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExplodeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ExplodeAttributes *) to) = *((ExplodeAttributes *) from);
}
