// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtEllipsoidSliceFilter.h
// ************************************************************************* //

#ifndef AVT_EllipsoidSlice_FILTER_H
#define AVT_EllipsoidSlice_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <EllipsoidSliceAttributes.h>


// ****************************************************************************
//  Class: avtEllipsoidSliceFilter
//
//  Purpose:
//      A plugin operator for EllipsoidSlice.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Jun 3 09:44:03 PDT 2014
//
//  Modifications:
//    Eric Brugger, Thu Jul 24 13:22:53 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtEllipsoidSliceFilter : public avtPluginDataTreeIterator
{
  public:
                         avtEllipsoidSliceFilter();
    virtual             ~avtEllipsoidSliceFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtEllipsoidSliceFilter"; };
    virtual const char  *GetDescription(void)
                             { return "EllipsoidSlice"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    EllipsoidSliceAttributes       atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
};


#endif
