// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisEllipsoidSliceWindow.h"

#include <EllipsoidSliceAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::QvisEllipsoidSliceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisEllipsoidSliceWindow::QvisEllipsoidSliceWindow(const int type,
                         EllipsoidSliceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::~QvisEllipsoidSliceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisEllipsoidSliceWindow::~QvisEllipsoidSliceWindow()
{
}


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEllipsoidSliceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    originLabel = new QLabel(tr("Origin"), central);
    mainLayout->addWidget(originLabel,0,0);
    origin = new QLineEdit(central);
    connect(origin, SIGNAL(returnPressed()),
            this, SLOT(originProcessText()));
    mainLayout->addWidget(origin, 0,1);

    radiiLabel = new QLabel(tr("Radii"), central);
    mainLayout->addWidget(radiiLabel,1,0);
    radii = new QLineEdit(central);
    connect(radii, SIGNAL(returnPressed()),
            this, SLOT(radiiProcessText()));
    mainLayout->addWidget(radii, 1,1);

    rotationAngleLabel = new QLabel(tr("Rotation Angle"), central);
    mainLayout->addWidget(rotationAngleLabel,2,0);
    rotationAngle = new QLineEdit(central);
    connect(rotationAngle, SIGNAL(returnPressed()),
            this, SLOT(rotationAngleProcessText()));
    mainLayout->addWidget(rotationAngle, 2,1);

}


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEllipsoidSliceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case EllipsoidSliceAttributes::ID_origin:
            origin->setText(DoublesToQString(atts->GetOrigin(), 3));
            break;
          case EllipsoidSliceAttributes::ID_radii:
            radii->setText(DoublesToQString(atts->GetRadii(), 3));
            break;
          case EllipsoidSliceAttributes::ID_rotationAngle:
            rotationAngle->setText(DoublesToQString(atts->GetRotationAngle(), 3));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisEllipsoidSliceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEllipsoidSliceWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do origin
    if(which_widget == EllipsoidSliceAttributes::ID_origin || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(origin, val, 3))
            atts->SetOrigin(val);
        else
        {
            ResettingError(tr("Origin"),
                DoublesToQString(atts->GetOrigin(),3));
            atts->SetOrigin(atts->GetOrigin());
        }
    }

    // Do radii
    if(which_widget == EllipsoidSliceAttributes::ID_radii || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(radii, val, 3))
            atts->SetRadii(val);
        else
        {
            ResettingError(tr("Radii"),
                DoublesToQString(atts->GetRadii(),3));
            atts->SetRadii(atts->GetRadii());
        }
    }

    // Do rotationAngle
    if(which_widget == EllipsoidSliceAttributes::ID_rotationAngle || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(rotationAngle, val, 3))
            atts->SetRotationAngle(val);
        else
        {
            ResettingError(tr("Rotation Angle"),
                DoublesToQString(atts->GetRotationAngle(),3));
            atts->SetRotationAngle(atts->GetRotationAngle());
        }
    }

}


//
// Qt Slot functions
//


void
QvisEllipsoidSliceWindow::originProcessText()
{
    GetCurrentValues(EllipsoidSliceAttributes::ID_origin);
    Apply();
}


void
QvisEllipsoidSliceWindow::radiiProcessText()
{
    GetCurrentValues(EllipsoidSliceAttributes::ID_radii);
    Apply();
}


void
QvisEllipsoidSliceWindow::rotationAngleProcessText()
{
    GetCurrentValues(EllipsoidSliceAttributes::ID_rotationAngle);
    Apply();
}


