// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: EllipsoidSlicePluginInfo.C
// ****************************************************************************

#include <EllipsoidSlicePluginInfo.h>
#include <EllipsoidSliceAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(EllipsoidSlice,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(EllipsoidSlice,General)

// ****************************************************************************
//  Method: EllipsoidSliceGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
EllipsoidSliceGeneralPluginInfo::GetName() const
{
    return "EllipsoidSlice";
}

// ****************************************************************************
//  Method: EllipsoidSliceGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
EllipsoidSliceGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: EllipsoidSliceGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
EllipsoidSliceGeneralPluginInfo::GetID() const
{
    return "EllipsoidSlice_1.0";
}
// ****************************************************************************
//  Method: EllipsoidSliceGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
EllipsoidSliceGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: EllipsoidSliceGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
EllipsoidSliceGeneralPluginInfo::GetCategoryName() const
{
    return "Slicing";
}
