// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <EllipsoidSliceAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: EllipsoidSliceAttributes::EllipsoidSliceAttributes
//
// Purpose:
//   Init utility for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void EllipsoidSliceAttributes::Init()
{
    origin[0] = 0;
    origin[1] = 0;
    origin[2] = 0;
    radii[0] = 1;
    radii[1] = 1;
    radii[2] = 1;
    rotationAngle[0] = 0;
    rotationAngle[1] = 0;
    rotationAngle[2] = 0;

    EllipsoidSliceAttributes::SelectAll();
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::EllipsoidSliceAttributes
//
// Purpose:
//   Copy utility for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void EllipsoidSliceAttributes::Copy(const EllipsoidSliceAttributes &obj)
{
    origin[0] = obj.origin[0];
    origin[1] = obj.origin[1];
    origin[2] = obj.origin[2];

    radii[0] = obj.radii[0];
    radii[1] = obj.radii[1];
    radii[2] = obj.radii[2];

    rotationAngle[0] = obj.rotationAngle[0];
    rotationAngle[1] = obj.rotationAngle[1];
    rotationAngle[2] = obj.rotationAngle[2];


    EllipsoidSliceAttributes::SelectAll();
}

// Type map format string
const char *EllipsoidSliceAttributes::TypeMapFormatString = ELLIPSOIDSLICEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t EllipsoidSliceAttributes::TmfsStruct = {ELLIPSOIDSLICEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: EllipsoidSliceAttributes::EllipsoidSliceAttributes
//
// Purpose:
//   Default constructor for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EllipsoidSliceAttributes::EllipsoidSliceAttributes() :
    AttributeSubject(EllipsoidSliceAttributes::TypeMapFormatString)
{
    EllipsoidSliceAttributes::Init();
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::EllipsoidSliceAttributes
//
// Purpose:
//   Constructor for the derived classes of EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EllipsoidSliceAttributes::EllipsoidSliceAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    EllipsoidSliceAttributes::Init();
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::EllipsoidSliceAttributes
//
// Purpose:
//   Copy constructor for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EllipsoidSliceAttributes::EllipsoidSliceAttributes(const EllipsoidSliceAttributes &obj) :
    AttributeSubject(EllipsoidSliceAttributes::TypeMapFormatString)
{
    EllipsoidSliceAttributes::Copy(obj);
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::EllipsoidSliceAttributes
//
// Purpose:
//   Copy constructor for derived classes of the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EllipsoidSliceAttributes::EllipsoidSliceAttributes(const EllipsoidSliceAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    EllipsoidSliceAttributes::Copy(obj);
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::~EllipsoidSliceAttributes
//
// Purpose:
//   Destructor for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EllipsoidSliceAttributes::~EllipsoidSliceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::operator =
//
// Purpose:
//   Assignment operator for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

EllipsoidSliceAttributes&
EllipsoidSliceAttributes::operator = (const EllipsoidSliceAttributes &obj)
{
    if (this == &obj) return *this;

    EllipsoidSliceAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EllipsoidSliceAttributes::operator == (const EllipsoidSliceAttributes &obj) const
{
    // Compare the origin arrays.
    bool origin_equal = true;
    for(int i = 0; i < 3 && origin_equal; ++i)
        origin_equal = (origin[i] == obj.origin[i]);

    // Compare the radii arrays.
    bool radii_equal = true;
    for(int i = 0; i < 3 && radii_equal; ++i)
        radii_equal = (radii[i] == obj.radii[i]);

    // Compare the rotationAngle arrays.
    bool rotationAngle_equal = true;
    for(int i = 0; i < 3 && rotationAngle_equal; ++i)
        rotationAngle_equal = (rotationAngle[i] == obj.rotationAngle[i]);

    // Create the return value
    return (origin_equal &&
            radii_equal &&
            rotationAngle_equal);
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EllipsoidSliceAttributes::operator != (const EllipsoidSliceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::TypeName
//
// Purpose:
//   Type name method for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
EllipsoidSliceAttributes::TypeName() const
{
    return "EllipsoidSliceAttributes";
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EllipsoidSliceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const EllipsoidSliceAttributes *tmp = (const EllipsoidSliceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
EllipsoidSliceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new EllipsoidSliceAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the EllipsoidSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
EllipsoidSliceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new EllipsoidSliceAttributes(*this);
    else
        retval = new EllipsoidSliceAttributes;

    return retval;
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
EllipsoidSliceAttributes::SelectAll()
{
    Select(ID_origin,        (void *)origin, 3);
    Select(ID_radii,         (void *)radii, 3);
    Select(ID_rotationAngle, (void *)rotationAngle, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EllipsoidSliceAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EllipsoidSliceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    EllipsoidSliceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for EllipsoidSliceAttributes.
    DataNode *node = new DataNode("EllipsoidSliceAttributes");

    if(completeSave || !FieldsEqual(ID_origin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("origin", origin, 3));
    }

    if(completeSave || !FieldsEqual(ID_radii, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radii", radii, 3));
    }

    if(completeSave || !FieldsEqual(ID_rotationAngle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("rotationAngle", rotationAngle, 3));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
EllipsoidSliceAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("EllipsoidSliceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("origin")) != 0)
        SetOrigin(node->AsDoubleArray());
    if((node = searchNode->GetNode("radii")) != 0)
        SetRadii(node->AsDoubleArray());
    if((node = searchNode->GetNode("rotationAngle")) != 0)
        SetRotationAngle(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
EllipsoidSliceAttributes::SetOrigin(const double *origin_)
{
    origin[0] = origin_[0];
    origin[1] = origin_[1];
    origin[2] = origin_[2];
    Select(ID_origin, (void *)origin, 3);
}

void
EllipsoidSliceAttributes::SetRadii(const double *radii_)
{
    radii[0] = radii_[0];
    radii[1] = radii_[1];
    radii[2] = radii_[2];
    Select(ID_radii, (void *)radii, 3);
}

void
EllipsoidSliceAttributes::SetRotationAngle(const double *rotationAngle_)
{
    rotationAngle[0] = rotationAngle_[0];
    rotationAngle[1] = rotationAngle_[1];
    rotationAngle[2] = rotationAngle_[2];
    Select(ID_rotationAngle, (void *)rotationAngle, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
EllipsoidSliceAttributes::GetOrigin() const
{
    return origin;
}

double *
EllipsoidSliceAttributes::GetOrigin()
{
    return origin;
}

const double *
EllipsoidSliceAttributes::GetRadii() const
{
    return radii;
}

double *
EllipsoidSliceAttributes::GetRadii()
{
    return radii;
}

const double *
EllipsoidSliceAttributes::GetRotationAngle() const
{
    return rotationAngle;
}

double *
EllipsoidSliceAttributes::GetRotationAngle()
{
    return rotationAngle;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
EllipsoidSliceAttributes::SelectOrigin()
{
    Select(ID_origin, (void *)origin, 3);
}

void
EllipsoidSliceAttributes::SelectRadii()
{
    Select(ID_radii, (void *)radii, 3);
}

void
EllipsoidSliceAttributes::SelectRotationAngle()
{
    Select(ID_rotationAngle, (void *)rotationAngle, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EllipsoidSliceAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
EllipsoidSliceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_origin:        return "origin";
    case ID_radii:         return "radii";
    case ID_rotationAngle: return "rotationAngle";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
EllipsoidSliceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_origin:        return FieldType_doubleArray;
    case ID_radii:         return FieldType_doubleArray;
    case ID_rotationAngle: return FieldType_doubleArray;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
EllipsoidSliceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_origin:        return "doubleArray";
    case ID_radii:         return "doubleArray";
    case ID_rotationAngle: return "doubleArray";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EllipsoidSliceAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EllipsoidSliceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const EllipsoidSliceAttributes &obj = *((const EllipsoidSliceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_origin:
        {  // new scope
        // Compare the origin arrays.
        bool origin_equal = true;
        for(int i = 0; i < 3 && origin_equal; ++i)
            origin_equal = (origin[i] == obj.origin[i]);

        retval = origin_equal;
        }
        break;
    case ID_radii:
        {  // new scope
        // Compare the radii arrays.
        bool radii_equal = true;
        for(int i = 0; i < 3 && radii_equal; ++i)
            radii_equal = (radii[i] == obj.radii[i]);

        retval = radii_equal;
        }
        break;
    case ID_rotationAngle:
        {  // new scope
        // Compare the rotationAngle arrays.
        bool rotationAngle_equal = true;
        for(int i = 0; i < 3 && rotationAngle_equal; ++i)
            rotationAngle_equal = (rotationAngle[i] == obj.rotationAngle[i]);

        retval = rotationAngle_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

