// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtElevateFilter.h
// ************************************************************************* //

#ifndef AVT_Elevate_FILTER_H
#define AVT_Elevate_FILTER_H


#include <avtPluginFilter.h>
#include <avtSingleFilterFacade.h>

#include <ElevateAttributes.h>


class avtSurfaceFilter;


// ****************************************************************************
//  Class: avtElevateFilter
//
//  Purpose:
//      A plugin operator for Elevate.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
//  Modifications:
//
//    Tom Fogal, Tue Jun 23 20:46:11 MDT 2009
//    Added const version of GetFacadedFilter.
//
// ****************************************************************************

class avtElevateFilter : virtual public avtPluginFilter,
                         virtual public avtSingleFilterFacade
{
  public:
                         avtElevateFilter();
    virtual             ~avtElevateFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtElevateFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Elevating"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    avtSurfaceFilter   *surface_filter;
    ElevateAttributes   atts;

    virtual avtFilter        *GetFacadedFilter();
    virtual const avtFilter  *GetFacadedFilter() const;

    static void UpdateDataObjectInfoCB(avtDataObject_p &input,
                                       avtDataObject_p &output, void *);
};


#endif
