// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtElevateFilter.C
// ************************************************************************* //

#include <avtElevateFilter.h>

#include <avtSurfaceFilter.h>
#include <SurfaceFilterAttributes.h>

// ****************************************************************************
//  Method: avtElevateFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

avtElevateFilter::avtElevateFilter()
{
    surface_filter = NULL;
}


// ****************************************************************************
//  Method: avtElevateFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
//  Modifications:
//
// ****************************************************************************

avtElevateFilter::~avtElevateFilter()
{
    if (surface_filter != NULL)
    {
        delete surface_filter;
        surface_filter = NULL;
    }
}


// ****************************************************************************
//  Method:  avtElevateFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

avtFilter *
avtElevateFilter::Create()
{
    return new avtElevateFilter();
}


// ****************************************************************************
//  Method:      avtElevateFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
//  Modifications:
//    Sean Ahern, Tue Aug 14 11:47:14 EDT 2007
//    Added the "zero" flag.
//
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtElevateFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const ElevateAttributes*)a;
 
    if (surface_filter != NULL)
    {
        delete surface_filter;
    }

    SurfaceFilterAttributes sf_atts;
    sf_atts.SetLimitsMode(
                   (SurfaceFilterAttributes::LimitsMode) atts.GetLimitsMode());
    sf_atts.SetMinFlag(atts.GetMinFlag());
    sf_atts.SetMaxFlag(atts.GetMaxFlag());
    sf_atts.SetZeroFlag(atts.GetZeroFlag());
    sf_atts.SetScaling((SurfaceFilterAttributes::Scaling) atts.GetScaling());
    sf_atts.SetSkewFactor(atts.GetSkewFactor());
    sf_atts.SetMin(atts.GetMin());
    sf_atts.SetMax(atts.GetMax());
    sf_atts.SetVariable(atts.GetVariable());
    sf_atts.SetGenerateNodalOutput(false);

    // Convert ElevateAttributes::ScalingMode to SurfaceFilterAttributes::ScalingMode
    sf_atts.SetUseXYLimits((SurfaceFilterAttributes::ScalingMode) atts.GetUseXYLimits());
    surface_filter = new avtSurfaceFilter(&sf_atts);
    surface_filter->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
}


// ****************************************************************************
//  Method: avtElevateFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtElevateFilter with the given
//      parameters would result in an equivalent avtElevateFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Jan 30 13:31:28 PST 2005
//
// ****************************************************************************

bool
avtElevateFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(ElevateAttributes*)a);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   January 29, 2005
//
// ****************************************************************************

avtFilter *
avtElevateFilter::GetFacadedFilter(void)
{
    return surface_filter;
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtElevateFilter::GetFacadedFilter(void) const
{
    return surface_filter;
}

// ****************************************************************************
// Method: avtElevateFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtElevateFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    outAtts.AddFilterMetaData("Elevate");
}
