// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ElevateScriptingPluginInfo.C
// ************************************************************************* //
#include <PyElevateAttributes.h>
#include <ElevatePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Elevate,Scripting)

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ElevateScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyElevateAttributes_StartUp((ElevateAttributes *)subj, data);
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ElevateScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyElevateAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Elevate plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ElevateScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyElevateAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ElevateScriptingPluginInfo::GetLogString()
{
    std::string s(PyElevateAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ElevateScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ElevateScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyElevateAttributes_SetDefaults((const ElevateAttributes *)atts);
}
