// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ElevateGUIPluginInfo.C
// ****************************************************************************

#include <ElevatePluginInfo.h>
#include <ElevateAttributes.h>
#include <QApplication>
#include <QvisElevateWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Elevate,GUI)

// ****************************************************************************
//  Method: ElevateGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
ElevateGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Elevate"));
}


// ****************************************************************************
//  Method: ElevateGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
ElevateGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisElevateWindow(type, (ElevateAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: ElevateGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Elevate.xpm>
const char **
ElevateGUIPluginInfo::XPMIconData() const
{
    return Elevate_xpm;
}

