// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisEdgeWindow.h"

#include <EdgeAttributes.h>

#include <QCheckBox>
#include <QLayout>


// ****************************************************************************
// Method: QvisEdgeWindow::QvisEdgeWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisEdgeWindow::QvisEdgeWindow(const int type,
                         EdgeAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisEdgeWindow::~QvisEdgeWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisEdgeWindow::~QvisEdgeWindow()
{
}


// ****************************************************************************
// Method: QvisEdgeWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEdgeWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    dummy = new QCheckBox(tr("dummy"), central);
    connect(dummy, SIGNAL(toggled(bool)),
            this, SLOT(dummyChanged(bool)));
    mainLayout->addWidget(dummy, 0,0);

}


// ****************************************************************************
// Method: QvisEdgeWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEdgeWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case EdgeAttributes::ID_dummy:
            dummy->blockSignals(true);
            dummy->setChecked(atts->GetDummy());
            dummy->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisEdgeWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisEdgeWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisEdgeWindow::dummyChanged(bool val)
{
    atts->SetDummy(val);
    SetUpdate(false);
    Apply();
}


