// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef EDGEATTRIBUTES_H
#define EDGEATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: EdgeAttributes
//
// Purpose:
//    Attributes for the Edge operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class EdgeAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    EdgeAttributes();
    EdgeAttributes(const EdgeAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    EdgeAttributes(private_tmfs_t tmfs);
    EdgeAttributes(const EdgeAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~EdgeAttributes();

    virtual EdgeAttributes& operator = (const EdgeAttributes &obj);
    virtual bool operator == (const EdgeAttributes &obj) const;
    virtual bool operator != (const EdgeAttributes &obj) const;
private:
    void Init();
    void Copy(const EdgeAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetDummy(bool dummy_);

    // Property getting methods
    bool GetDummy() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_dummy = 0,
        ID__LAST
    };

private:
    bool dummy;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define EDGEATTRIBUTES_TMFS "b"

#endif
