// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISDUALMESHWINDOW_H
#define QVISDUALMESHWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class DualMeshAttributes;
class QLabel;
class QButtonGroup;

// ****************************************************************************
// Class: QvisDualMeshWindow
//
// Purpose:
//    Defines QvisDualMeshWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisDualMeshWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisDualMeshWindow(const int type,
                         DualMeshAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisDualMeshWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void modeChanged(int val);
  private:
    QButtonGroup *mode;
    QLabel *modeLabel;

    DualMeshAttributes *atts;
};



#endif
