// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisDualMeshWindow.h"

#include <DualMeshAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisDualMeshWindow::QvisDualMeshWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDualMeshWindow::QvisDualMeshWindow(const int type,
                         DualMeshAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisDualMeshWindow::~QvisDualMeshWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDualMeshWindow::~QvisDualMeshWindow()
{
}


// ****************************************************************************
// Method: QvisDualMeshWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, on Aug 18 20:13:20 PDT 2008
//   Qt4 Port - Autogen + Changed labels of radio buttons.   
//
// ****************************************************************************

void
QvisDualMeshWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    modeLabel = new QLabel(tr("Conversion Mode:"), central);
    mainLayout->addWidget(modeLabel,0,0);
    QWidget *modeWidget = new QWidget(central);
    mode = new QButtonGroup(modeWidget);
    QHBoxLayout *modeLayout = new QHBoxLayout(modeWidget);
    modeLayout->setMargin(0);
    modeLayout->setSpacing(10);
    QRadioButton *modeConversionModeAuto = new QRadioButton(tr("Auto"), modeWidget);
    mode->addButton(modeConversionModeAuto,0);
    modeLayout->addWidget(modeConversionModeAuto);
    QRadioButton *modeConversionModeNodesToZones = new QRadioButton(tr("Nodes to Zones"), modeWidget);
    mode->addButton(modeConversionModeNodesToZones,1);
    modeLayout->addWidget(modeConversionModeNodesToZones);
    QRadioButton *modeConversionModeZonesToNodes = new QRadioButton(tr("Zones to Nodes"), modeWidget);
    mode->addButton(modeConversionModeZonesToNodes,2);
    modeLayout->addWidget(modeConversionModeZonesToNodes);
    connect(mode, SIGNAL(buttonClicked(int)),
            this, SLOT(modeChanged(int)));
    mainLayout->addWidget(modeWidget, 0,1);

}


// ****************************************************************************
// Method: QvisDualMeshWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDualMeshWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case DualMeshAttributes::ID_mode:
            mode->blockSignals(true);
            if(mode->button((int)atts->GetMode()) != 0)
                mode->button((int)atts->GetMode())->setChecked(true);
            mode->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisDualMeshWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDualMeshWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisDualMeshWindow::modeChanged(int val)
{
    if(val != atts->GetMode())
    {
        atts->SetMode(DualMeshAttributes::ConversionMode(val));
        SetUpdate(false);
        Apply();
    }
}


