// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: DualMeshAttributes
//
// Purpose:
//    Atts for Dual Mesh Operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class DualMeshAttributes extends AttributeSubject implements Plugin
{
    private static int DualMeshAttributes_numAdditionalAtts = 1;

    // Enum values
    public final static int CONVERSIONMODE_AUTO = 0;
    public final static int CONVERSIONMODE_NODESTOZONES = 1;
    public final static int CONVERSIONMODE_ZONESTONODES = 2;


    public DualMeshAttributes()
    {
        super(DualMeshAttributes_numAdditionalAtts);

        mode = CONVERSIONMODE_AUTO;
    }

    public DualMeshAttributes(int nMoreFields)
    {
        super(DualMeshAttributes_numAdditionalAtts + nMoreFields);

        mode = CONVERSIONMODE_AUTO;
    }

    public DualMeshAttributes(DualMeshAttributes obj)
    {
        super(obj);

        mode = obj.mode;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return DualMeshAttributes_numAdditionalAtts;
    }

    public boolean equals(DualMeshAttributes obj)
    {
        // Create the return value
        return ((mode == obj.mode));
    }

    public String GetName() { return "DualMesh"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetMode(int mode_)
    {
        mode = mode_;
        Select(0);
    }

    // Property getting methods
    public int GetMode() { return mode; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(mode);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetMode(buf.ReadInt());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "mode = ";
        if(mode == CONVERSIONMODE_AUTO)
            str = str + "CONVERSIONMODE_AUTO";
        if(mode == CONVERSIONMODE_NODESTOZONES)
            str = str + "CONVERSIONMODE_NODESTOZONES";
        if(mode == CONVERSIONMODE_ZONESTONODES)
            str = str + "CONVERSIONMODE_ZONESTONODES";
        str = str + "\n";
        return str;
    }


    // Attributes
    private int mode;
}

