// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef DUALMESHATTRIBUTES_H
#define DUALMESHATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: DualMeshAttributes
//
// Purpose:
//    Atts for Dual Mesh Operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DualMeshAttributes : public AttributeSubject
{
public:
    enum ConversionMode
    {
        Auto,
        NodesToZones,
        ZonesToNodes
    };

    // These constructors are for objects of this class
    DualMeshAttributes();
    DualMeshAttributes(const DualMeshAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    DualMeshAttributes(private_tmfs_t tmfs);
    DualMeshAttributes(const DualMeshAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~DualMeshAttributes();

    virtual DualMeshAttributes& operator = (const DualMeshAttributes &obj);
    virtual bool operator == (const DualMeshAttributes &obj) const;
    virtual bool operator != (const DualMeshAttributes &obj) const;
private:
    void Init();
    void Copy(const DualMeshAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetMode(ConversionMode mode_);

    // Property getting methods
    ConversionMode GetMode() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string ConversionMode_ToString(ConversionMode);
    static bool ConversionMode_FromString(const std::string &, ConversionMode &);
protected:
    static std::string ConversionMode_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_mode = 0,
        ID__LAST
    };

private:
    int mode;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define DUALMESHATTRIBUTES_TMFS "i"

#endif
