// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtDisplacePluginFilter.C
// ************************************************************************* //

#include <avtDisplacePluginFilter.h>

#include <avtDisplaceFilter.h>
#include <DisplaceAttributes.h>

// ****************************************************************************
//  Method: avtDisplacePluginFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
// ****************************************************************************

avtDisplacePluginFilter::avtDisplacePluginFilter()
{
    displacer = NULL;
}


// ****************************************************************************
//  Method: avtDisplacePluginFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
//  Modifications:
//
// ****************************************************************************

avtDisplacePluginFilter::~avtDisplacePluginFilter()
{
    if (displacer != NULL)
    {
        delete displacer;
        displacer = NULL;
    }
}


// ****************************************************************************
//  Method:  avtDisplacePluginFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
// ****************************************************************************

avtFilter *
avtDisplacePluginFilter::Create()
{
    return new avtDisplacePluginFilter();
}


// ****************************************************************************
//  Method:      avtDisplacePluginFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
//  Modifications:
//
//    Hank Childs, Fri Sep 30 09:16:06 PDT 2005
//    Add support for distributed resampling.
//
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtDisplacePluginFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const DisplaceAttributes*)a;

    //
    // Construct a new resample filter based on these attributes.
    //
    if (displacer != NULL)
    {
        delete displacer;
    }

    displacer = new avtDisplaceFilter();
    displacer->SetVariable(atts.GetVariable());
    displacer->SetFactor(atts.GetFactor());
    displacer->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
}


// ****************************************************************************
//  Method: avtDisplacePluginFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtDisplacePluginFilter with the given
//      parameters would result in an equivalent avtDisplacePluginFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
// ****************************************************************************

bool
avtDisplacePluginFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(DisplaceAttributes*)a);
}


// ****************************************************************************
//  Method: avtDisplacePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   May 18, 2007
//
// ****************************************************************************

avtFilter *
avtDisplacePluginFilter::GetFacadedFilter(void)
{
    return displacer;
}


// ****************************************************************************
//  Method: avtDisplacePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtDisplacePluginFilter::GetFacadedFilter(void) const
{
    return displacer;
}

// ****************************************************************************
// Method: avtDisplacePluginFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtDisplacePluginFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    outAtts.AddFilterMetaData("Displace");
}
