// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DisplaceCommonPluginInfo.C
// ****************************************************************************

#include <DisplacePluginInfo.h>
#include <DisplaceAttributes.h>

// ****************************************************************************
//  Method: DisplaceCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DisplaceCommonPluginInfo::AllocAttributes()
{
    return new DisplaceAttributes;
}

// ****************************************************************************
//  Method: DisplaceCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Displace attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DisplaceCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((DisplaceAttributes *) to) = *((DisplaceAttributes *) from);
}
