// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisDelaunayWindow.h"

#include <DelaunayAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisDelaunayWindow::QvisDelaunayWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDelaunayWindow::QvisDelaunayWindow(const int type,
                         DelaunayAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisDelaunayWindow::~QvisDelaunayWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDelaunayWindow::~QvisDelaunayWindow()
{
}


// ****************************************************************************
// Method: QvisDelaunayWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDelaunayWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    dimensionLabel = new QLabel(tr("Dimension"), central);
    mainLayout->addWidget(dimensionLabel,0,0);
    dimension = new QWidget(central);
    dimensionButtonGroup= new QButtonGroup(dimension);
    QHBoxLayout *dimensionLayout = new QHBoxLayout(dimension);
    dimensionLayout->setMargin(0);
    dimensionLayout->setSpacing(10);
    QRadioButton *dimensionDimensionAutomatic = new QRadioButton(tr("Automatic"), dimension);
    dimensionButtonGroup->addButton(dimensionDimensionAutomatic,0);
    dimensionLayout->addWidget(dimensionDimensionAutomatic);
    QRadioButton *dimensionDimensionTriangulation = new QRadioButton(tr("Triangulation"), dimension);
    dimensionButtonGroup->addButton(dimensionDimensionTriangulation,1);
    dimensionLayout->addWidget(dimensionDimensionTriangulation);
    QRadioButton *dimensionDimensionTetrahedralization = new QRadioButton(tr("Tetrahedralization"), dimension);
    dimensionButtonGroup->addButton(dimensionDimensionTetrahedralization,2);
    dimensionLayout->addWidget(dimensionDimensionTetrahedralization);
    connect(dimensionButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(dimensionChanged(int)));
    mainLayout->addWidget(dimension, 0,1);

}


// ****************************************************************************
// Method: QvisDelaunayWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDelaunayWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case DelaunayAttributes::ID_dimension:
            dimensionButtonGroup->blockSignals(true);
            if(dimensionButtonGroup->button((int)atts->GetDimension()) != 0)
                dimensionButtonGroup->button((int)atts->GetDimension())->setChecked(true);
            dimensionButtonGroup->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisDelaunayWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDelaunayWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisDelaunayWindow::dimensionChanged(int val)
{
    if(val != atts->GetDimension())
    {
        atts->SetDimension(DelaunayAttributes::Dimension(val));
        SetUpdate(false);
        Apply();
    }
}


