// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DelaunayPluginInfo.C
// ****************************************************************************

#include <DelaunayPluginInfo.h>
#include <DelaunayAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Delaunay,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(Delaunay,General)

// ****************************************************************************
//  Method: DelaunayGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DelaunayGeneralPluginInfo::GetName() const
{
    return "Delaunay";
}

// ****************************************************************************
//  Method: DelaunayGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DelaunayGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: DelaunayGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DelaunayGeneralPluginInfo::GetID() const
{
    return "Delaunay_1.0";
}
// ****************************************************************************
//  Method: DelaunayGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
DelaunayGeneralPluginInfo::EnabledByDefault() const
{
    return false;
}

// ****************************************************************************
//  Method: DelaunayGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DelaunayGeneralPluginInfo::GetCategoryName() const
{
    return "Geometry";
}
