// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef DELAUNAYATTRIBUTES_H
#define DELAUNAYATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: DelaunayAttributes
//
// Purpose:
//    Attributes for the Delaunay Operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DelaunayAttributes : public AttributeSubject
{
public:
    enum Dimension
    {
        Automatic,
        Triangulation,
        Tetrahedralization
    };

    // These constructors are for objects of this class
    DelaunayAttributes();
    DelaunayAttributes(const DelaunayAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    DelaunayAttributes(private_tmfs_t tmfs);
    DelaunayAttributes(const DelaunayAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~DelaunayAttributes();

    virtual DelaunayAttributes& operator = (const DelaunayAttributes &obj);
    virtual bool operator == (const DelaunayAttributes &obj) const;
    virtual bool operator != (const DelaunayAttributes &obj) const;
private:
    void Init();
    void Copy(const DelaunayAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetDimension(Dimension dimension_);

    // Property getting methods
    Dimension GetDimension() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Dimension_ToString(Dimension);
    static bool Dimension_FromString(const std::string &, Dimension &);
protected:
    static std::string Dimension_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_dimension = 0,
        ID__LAST
    };

private:
    int dimension;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define DELAUNAYATTRIBUTES_TMFS "i"

#endif
