// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtDeferExpressionFilter.h
// ************************************************************************* //

#ifndef AVT_DeferExpression_FILTER_H
#define AVT_DeferExpression_FILTER_H


#include <avtDeferExpressionBaseFilter.h>
#include <avtSingleFilterFacade.h>
#include <avtPluginFilter.h>

#include <DeferExpressionAttributes.h>


// ****************************************************************************
//  Class: avtDeferExpressionFilter
//
//  Purpose:
//      A plugin operator for DeferExpression.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Thu Sep 1 06:35:41 PDT 2005
//
//  Modifications:
//
//    Hank Childs, Thu Sep 23 16:46:26 PDT 2010
//    Refactor module so that piece is in avtDeferExpressionBaseFilter and
//    part remains here.  (This allows other filters to make use of its logic).
//
// ****************************************************************************

class avtDeferExpressionFilter : virtual public avtPluginFilter,
                                 virtual public avtDeferExpressionBaseFilter
{
  public:
                         avtDeferExpressionFilter();
    virtual             ~avtDeferExpressionFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtDeferExpressionFilter"; };
    virtual const char  *GetDescription(void)
                             { return "DeferExpression"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    DeferExpressionAttributes      atts;
    void                           GetVariablesToEvaluate(std::vector<std::string> &);
};


#endif
