// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DeferExpressionViewerEnginePluginInfo.C
// ****************************************************************************

#include <DeferExpressionPluginInfo.h>
#include <DeferExpressionAttributes.h>

//
// Storage for static data elements.
//
DeferExpressionAttributes *DeferExpressionViewerEnginePluginInfo::clientAtts = NULL;
DeferExpressionAttributes *DeferExpressionViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  DeferExpressionViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
DeferExpressionViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (DeferExpressionViewerEnginePluginInfo::clientAtts == NULL)
    {
        DeferExpressionViewerEnginePluginInfo::clientAtts  = new DeferExpressionAttributes;
        DeferExpressionViewerEnginePluginInfo::defaultAtts = new DeferExpressionAttributes;
    }
}

// ****************************************************************************
//  Method: DeferExpressionViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DeferExpressionViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: DeferExpressionViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DeferExpressionViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: DeferExpressionViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DeferExpressionViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(DeferExpressionAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: DeferExpressionViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DeferExpressionViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(DeferExpressionAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: DeferExpressionViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DeferExpressionViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(DeferExpressionAttributes*)atts = *defaultAtts;
    else
        *(DeferExpressionAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: DeferExpressionViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DeferExpressionViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: DeferExpressionViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DeferExpressionViewerEnginePluginInfo::GetMenuName() const
{
    return "DeferExpression";
}

