// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  DeferExpressionScriptingPluginInfo.C
// ************************************************************************* //
#include <PyDeferExpressionAttributes.h>
#include <DeferExpressionPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(DeferExpression,Scripting)

// ****************************************************************************
// Method: DeferExpressionScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DeferExpressionScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyDeferExpressionAttributes_StartUp((DeferExpressionAttributes *)subj, data);
}

// ****************************************************************************
// Method: DeferExpressionScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
DeferExpressionScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyDeferExpressionAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: DeferExpressionScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is DeferExpression plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DeferExpressionScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyDeferExpressionAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: DeferExpressionScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
DeferExpressionScriptingPluginInfo::GetLogString()
{
    std::string s(PyDeferExpressionAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: DeferExpressionScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DeferExpressionScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyDeferExpressionAttributes_SetDefaults((const DeferExpressionAttributes *)atts);
}
